% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_load}
\alias{fg_load}
\title{Load a flowGraph object from a specified folder path.}
\usage{
fg_load(folder_path)
}
\arguments{
\item{folder_path}{A string indicating the folder path to where a flowGraph
object was saved using the \code{fg_save} function.}
}
\value{
flowGraph object
}
\description{
Load a flowGraph object from a specified folder path.
}
\details{
see function \code{fg_save}
}
\examples{

 no_cores <- 1
 data(fg_data_pos2)
 fg <- flowGraph(fg_data_pos2$count, class=fg_data_pos2$meta$class,
                 no_cores=no_cores)

 fg_save(fg, "tmp")
 fg <- fg_load("tmp")
}
\seealso{
\code{\link[flowGraph]{fg_save}}
}
