% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_summary_desc}
\alias{fg_get_summary_desc}
\title{Retrieves a feature summary description table.}
\usage{
fg_get_summary_desc(fg)
}
\arguments{
\item{fg}{flowGraph object.}
}
\value{
A data frame where each row contains information
 on a feature summary from \code{fg}:
\itemize{
  \item{\code{type}: feature type (i.e. 'node' or 'edge').}
  \item{\code{feat}: feature name.}
  \item{\code{test_name}: summary name.}
  \item{\code{class}: class or the column name of \code{fg_get_meta(fg)}
   whose values represent the class label of each sample on which
   the summary was created for.}
  \item{\code{label1}: A string from the \code{class} column of the
   \code{meta} slot indicating the label of samples compared.}
  \item{\code{label2}: A string from the \code{class} column of the
   \code{meta} slot indicating the label of samples compared.}
}
}
\description{
Retrieves a feature summary description table for
 a given flowGraph object.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)

 fg_get_summary_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_summary}}
 \code{\link[flowGraph]{fg_add_summary}}
 \code{\link[flowGraph]{fg_rm_summary}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
}
