% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_feature}
\alias{fg_get_feature}
\title{Retrieves a feature matrix.}
\usage{
fg_get_feature(fg, type = "node", feature = "count")
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type 'node' or 'edge'.}

\item{feature}{A string indicating feature name;}
}
\value{
A numeric matrix of the specified feature values.
}
\description{
Retrieves a feature matrix from a given flowGraph object,
 the feature type, and feature name.
}
\details{
Returns \code{NULL} if the requested feature does not exist.
}
\examples{

 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=1)

 feature_matrix <- fg_get_feature(fg, type='node', feature='count')

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
 \code{\link[flowGraph]{fg_add_feature}}
 \code{\link[flowGraph]{fg_rm_feature}}
 \code{\link[flowGraph]{fg_get_summary}}
}
