% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_extract_samples}
\alias{fg_extract_samples}
\title{Extracts a set of samples from a flowGraph object.}
\usage{
fg_extract_samples(fg, sample_ids, rm_summary = TRUE)
}
\arguments{
\item{fg}{flowGraph object.}

\item{sample_ids}{A string vector of sample id's that the user wants to
keep in \code{fg}.}

\item{rm_summary}{A logical indicating whether or not to clear summary.}
}
\value{
flowGraph object.
}
\description{
Extracts or removes a specified set of samples from
 a flowGraph object.
}
\details{
The summaries in \code{fg} will not be modified;
 we recommend the user recalculates them.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg0 <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)
 fg_get_feature_desc(fg0)

 fg <- fg_extract_samples(fg0, fg_get_meta(fg0)$id[1:5])
 fg_get_feature_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
 \code{\link[flowGraph]{fg_merge}}
 \code{\link[flowGraph]{fg_extract_phenotypes}}
}
