% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_extract_phenotypes}
\alias{fg_extract_phenotypes}
\title{Extracts a set of phenotypes from a flowGraph object.}
\usage{
fg_extract_phenotypes(fg, phenotypes)
}
\arguments{
\item{fg}{flowGraph object.}

\item{phenotypes}{A string vector of phenotype or
cell population name labels.}
}
\value{
flowGraph object.
}
\description{
Extracts or removes a specified set of
 phenotypes from a flowGraph object.
}
\details{
The \code{summary} in \code{fg} will not be modified;
 we recommend users recalculate them.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg0 <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)
 fg_get_feature_desc(fg0)

 fg <- fg_extract_phenotypes(fg0, fg_get_graph(fg0)$v$phenotype[1:10])
 fg_get_feature_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
 \code{\link[flowGraph]{fg_merge}}
 \code{\link[flowGraph]{fg_extract_samples}}
 \code{\link[flowGraph]{fg_merge_samples}}
}
