% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowFrame-accessors.R, R/flowSet-accessors.R
\name{markernames}
\alias{markernames}
\alias{markernames,flowFrame-method}
\alias{markernames<-}
\alias{markernames<-,flowFrame-method}
\alias{markernames,flowSet-method}
\alias{markernames<-,flowSet-method}
\title{get or update the marker names}
\usage{
markernames(object, ...)

\S4method{markernames}{flowFrame}(object)

markernames(object) <- value

\S4method{markernames}{flowFrame}(object) <- value

\S4method{markernames}{flowSet}(object)

\S4method{markernames}{flowSet}(object) <- value
}
\arguments{
\item{object}{flowFrame or flowSet}

\item{...}{not used}

\item{value}{a named list or character vector. the names corresponds to the name(channel) and actual values are the desc(marker).}
}
\value{
marker names as a character vector. The marker names for FSC,SSC and Time channels are automatically excluded in the returned value.
When object is a flowSet and the marker names are not consistent across flowFrames, it returns a list of unique marker sets.
}
\description{
marker names corresponds to the 'desc' column of the phenoData of the flowFrame.
}
\details{
When extract marker names from a flowSet, it throws the warning if the marker names are not all the same across samples.
}
\examples{

data(GvHD)
fr <- GvHD[[1]]
markernames(fr)

chnls <- c("FL1-H", "FL3-H")
markers <- c("CD15", "CD14")
names(markers) <- chnls
markernames(fr) <- markers
markernames(fr)

fs <- GvHD[1:3]
markernames(fs)
}
