% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFragments.R
\name{plotFrags}
\alias{plotFrags}
\title{plotFrags}
\usage{
plotFrags(object, sample, specID, normalize = TRUE, ...)
}
\arguments{
\item{object}{an object of class "peaksDataset" where to keep the mass
spectra; both abundance (y) than m/z (x)}

\item{sample}{character, the sample from were to plot the mass spectra}

\item{specID}{numerical, a vector containing the index of the spectra to be
plotted.}

\item{normalize}{logical, if TRUE normalize the intensity of the mass peak
to 100, the most abundant is 100% and the other peaks are scaled
consequetially}

\item{...}{other parameter passed to the plot() function}
}
\description{
Plot the mass spectra from the profile matrix
}
\details{
Plot the deconvoluted mass spectra from the profile matrix
}
\examples{

files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam(snthresh = 3, ppm = 3000, peakwidth = c(3, 40),
 prefilter = c(3, 100), fitgauss = FALSE, integrate = 2, noise = 0,
 extendLengthMSW = TRUE, mzCenterFun = "wMean")
data <- addXCMSPeaks(files[1:2], data, settings = mfp)
data
## align two chromatogram
pA <- peaksAlignment(data@peaksdata[[1]], data@peaksdata[[2]],
                     data@peaksrt[[1]], data@peaksrt[[2]], D = 50,
                     metric = 3, compress = FALSE, type = 2, penality = 0.2)
pA@v$match
## plot the mass spectra
par(mfrow=c(2,1))
plotFrags(object=data, sample=1, specID=10)
plotFrags(object=data, sample=2, specID=12)

}
\author{
riccardo.romoli@unifi.it
}
