% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotDotPlot}
\alias{plotDotPlot}
\title{Visualizes fedup enrichment and depletion results using ggplot.}
\usage{
plotDotPlot(
    df,
    xVar,
    yVar,
    xLab = xVar,
    yLab = NULL,
    pTitle = NULL,
    fillVar = NULL,
    fillCol = NULL,
    fillLab = fillVar,
    sizeVar = NULL,
    sizeLab = sizeVar
)
}
\arguments{
\item{df}{(data.frame) table with fedup results generated via
\link[fedup]{runFedup}}

\item{xVar}{(char) x-axis variable (must be a column value in \code{df})}

\item{yVar}{(char) y-axis variable (must be a column value in \code{df})}

\item{xLab}{(char) x-axis label (default \code{xVar} value)}

\item{yLab}{(char) y-axis label (default NULL)}

\item{pTitle}{(char) plot title (default NULL)}

\item{fillVar}{(char) point fill variable (default NULL)}

\item{fillCol}{(char) point fill colours (default NULL)}

\item{fillLab}{(char) point fill label (default \code{fillVar} value)}

\item{sizeVar}{(char) point size variable (default NULL)}

\item{sizeLab}{(char) point size label (default \code{sizeVar} value)}
}
\value{
Object returned from ggplot with the enrichment dot plot.
}
\description{
This function supports any combination of numeric x-y variables
to plot from fedup results. The list outputted by \link[fedup]{runFedup}
must first be converted to a data.frame before plotting (see examples for
sample use).
}
\examples{
# Load example data
data(geneDouble)
data(pathwaysGMT)
# Load external libraries
suppressMessages(library(dplyr))
suppressMessages(library(tidyr))
# Run fedup
fedupRes <- runFedup(geneDouble, pathwaysGMT)
# Prepare dataframe from fedup results
fedupPlot <- fedupRes \%>\%
    bind_rows(.id = "set") \%>\%
    separate(col = "set", into = c("set", "sign"), sep = "_") \%>\%
    subset(qvalue < 0.01) \%>\%
    mutate(log10qvalue = -log10(qvalue)) \%>\%
    mutate(pathway = gsub("\\\\\%.*", "", pathway)) \%>\%
    as.data.frame()
# Plot
p <- plotDotPlot(
    df = fedupPlot,
    xVar = "log10qvalue",
    yVar = "pathway",
    xLab = "-log10(qvalue)",
    fillVar = "sign",
    fillLab = "Genetic interaction",
    fillCol = c("#0077f1", "#fcde24"),
    sizeVar = "fold_enrichment",
    sizeLab = "Fold enrichment"
)
}
