% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimTranscripts.R
\name{trimTranscripts}
\alias{trimTranscripts}
\title{Resize 5' and 3' ends of a transcript GenomicRanges}
\usage{
trimTranscripts(x, start = 0, end = 0)
}
\arguments{
\item{x}{GRanges or GRangesList object containing exon coordinates for each transcript}

\item{start}{Number of bases to trim from the start of transcript. Providing a negative 
value will extend the transcript instead. If `x` is a GRanges object,
`start` is a single integer. If `x` is a GRangesList, `start` can be a single
integer or a list of integers of the same length as `x`}

\item{end}{Number of bases to trim from the end of transcript. Providing a negative 
value will extend the transcript instead. If `x` is a GRanges object,
`end` is a single integer. If `x` is a GRangesList, `end` can be a single
integer or a list of integers of the same length as `x`}
}
\value{
Trimmed GenomicRanges object
}
\description{
Resize 5' and 3' ends of a transcript GenomicRanges
}
\examples{
library(GenomicRanges)
gr1 <- GRanges(
  seqnames = "chr1", strand = c("+", "+", "+"),
  ranges = IRanges(
    start = c(1, 500, 1000),
    end = c(100, 600, 1100)
  )
)

trimTranscripts(gr1, 20, 80)
trimTranscripts(gr1, 110, 150)
}
\author{
Fursham Hamid
}
