% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsettranscripts.R
\name{subsetNewTranscripts}
\alias{subsetNewTranscripts}
\title{Shortlist GTF GRanges object for new transcripts}
\usage{
subsetNewTranscripts(query, ref, refine.by = c("none", "intron", "cds"))
}
\arguments{
\item{query}{GRanges object containing query GTF data.}

\item{ref}{GRanges object containing reference GTF data.}

\item{refine.by}{Whether to refine the selection process by removing query transcripts with
similar introns or CDS structure to reference. Default input is "none", and 
can be changed to "intron" or "cds" respectively.}
}
\value{
Filtered GRanges GTF object
}
\description{
`subsetNewTranscripts()` will retain transcripts in `query` that are distinct
from those in `ref`
}
\details{
`subsetNewTranscripts()` will compare query and reference GTF GRanges and 
return query transcripts with different exon structures from reference 
transcripts. Transcriptome assemblers may sometime extend 5' and 3' ends 
of known transcripts based on experimental data. These annotated transcripts 
can be removed by inputting "intron" to the refine.by argument. This will 
further compare and remove transcripts of identical intron structures. 
Alternatively, transcripts with unique CDS coordinates can be selected by 
typing "cds" to the refine.by argument.
}
\examples{
# Load dataset
data(matched_query_gtf, ref_gtf)

# shortlist new transcripts
subsetNewTranscripts(matched_query_gtf, ref_gtf)
}
\author{
Fursham Hamid
}
