% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eachfunctions.R
\name{sorteach}
\alias{sorteach}
\title{Internally sort each element of a GenomicRangesList}
\usage{
sorteach(x, ...)
}
\arguments{
\item{x}{GRangesList object}

\item{...}{Comma separated list of unquoted variable names to sort by. Variables are 
names of metadata columns found in GRangesList object. Use desc() to sort a
variable in descending order. Input can be `exonorder` to sort each element 
in exon order}
}
\value{
Sorted GRangesList object
}
\description{
Internally sort each element of a GenomicRangesList
}
\examples{
# Load dataset
data(query_exons)

# sort elements in each GRangesList in descending coordinate order
query_exons_desc <- sorteach(query_exons, dplyr::desc(start))

# sort elements in each GRangesList in its order in transcript
query_exons_exonorder <- sorteach(query_exons_desc, exonorder)

# test similarity of query_exons and query_exons_exonorder
identical(query_exons, query_exons_exonorder)
}
\author{
Fursham Hamid
}
