% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchChromosomes.R
\name{matchChromosomes}
\alias{matchChromosomes}
\title{Match seqlevels of input GRanges to reference GRanges or BioString objects}
\usage{
matchChromosomes(x, to)
}
\arguments{
\item{x}{GRanges object with seqnames to change}

\item{to}{GRanges object from which seqnames is referenced}
}
\value{
Corrected input GRanges
}
\description{
A convenient wrapper to match seqlevels of a query GRanges object to a 
reference object that contain seqlevels information. Reference can be a 
GRanges, GRangesList, BioString or DNAString object. Seqlevels which fail 
to match will be dropped.
}
\examples{
## ---------------------------------------------------------------------
## EXAMPLE USING TOY DATASET
## ---------------------------------------------------------------------
require(GenomicRanges)

## Create toy GRanges objects
gr1 <- GRanges("1", IRanges(start = c(1, 101), width = c(20, 20)), "+")
gr2 <- GRanges("chr1", IRanges(start = c(1, 101), width = c(20, 20)), "+")

## Match Ensembl-style chromosomes from gr1 to UCSC-style gr2
matchChromosomes(gr1, gr2)

## Possible to match chrosomomes from GRanges object to a Biostrings 
#    object containing seqlevels
x0 <- c("chr2" = "CTCACCAGTAT", "chr3" = "TGTCAGTCGA")
dna <- Biostrings::DNAStringSet(x0)

## Match gr1 to dna
matchChromosomes(gr1, dna)
}
\author{
Fursham Hamid
}
