% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_consistentSeqLevels.R
\name{has_consistentSeqlevels}
\alias{has_consistentSeqlevels}
\title{Test consistency of chromosome naming styles 
(aka seqlevels; e.g. "chr1" vs "1") across multiple objects}
\usage{
has_consistentSeqlevels(..., verbose = TRUE)
}
\arguments{
\item{...}{Two or more objects with seqlevels information}

\item{verbose}{Whether to print out message}
}
\value{
Logical value as to whether all objects have consistent 
seqlevel styles
}
\description{
This function will determine if all input ranges objects have the 
same chromosome naming convention. Input objects can be GenomicRanges, 
BSgenome or Biostrings object with seqlevel information.
}
\examples{
## ---------------------------------------------------------------------
## EXAMPLE USING TOY DATASET
## ---------------------------------------------------------------------
require(GenomicRanges)

## Create toy GRanges objects
gr1 <- GRanges("1", IRanges(start = c(1, 101), width = c(20, 20)), "+")
gr2 <- GRanges("chr1", IRanges(start = c(1, 101), width = c(20, 20)), "+")

## Test for seqlevels consistency
has_consistentSeqlevels(gr1, gr2)

## Input can be a Biostrings object with seqlevels information
x0 <- c("chr2" = "CTCACCAGTAT", "chr3" = "TGTCAGTCGA")
dna <- Biostrings::DNAStringSet(x0)

## Test for seqlevels consistency
has_consistentSeqlevels(gr1, dna)
has_consistentSeqlevels(gr2, dna)
}
\author{
Fursham Hamid
}
