% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildCDS.R
\name{buildCDS}
\alias{buildCDS}
\title{Reference-guided construction of CDS on GTF object}
\usage{
buildCDS(query, ref, fasta)
}
\arguments{
\item{query}{GRanges object containing query GTF data.}

\item{ref}{GRanges object containing reference GTF data.}

\item{fasta}{BSgenome or Biostrings object containing genomic sequence}
}
\value{
GRanges object containing query exon entries and newly-constructed CDS
information
}
\description{
`buildCDS()` is designed to construct CDS information on transcripts from
query GTF object.
}
\details{
The `buildCDS()`function will first search for known reference mRNAs in
`query` and annotate its CDS information. For the remaining transcripts, 
`buildCDS()` will search for a putative translation start site using a 
database of annotated ATG codons from `ref`. Transcripts containing an 
open-reading frame will be assigned the newly-determined CDS information.
}
\examples{
# Load genome and datasets
library(BSgenome.Mmusculus.UCSC.mm10)
data(matched_query_gtf, ref_gtf)

# Build CDS
buildCDS(matched_query_gtf, ref_gtf, Mmusculus)
}
\author{
Fursham Hamid
}
