% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinctMC.R
\name{distinctMC}
\alias{distinctMC}
\title{Keep distinct ranges and mcols}
\usage{
distinctMC(x, ..., .keep_all = FALSE)
}
\arguments{
\item{x}{A GenomicRanges object}

\item{...}{\verb{<data-masking>} Passed to \link[dplyr]{distinct}}

\item{.keep_all}{If \code{TRUE}, keep all columns in \code{x}}
}
\value{
A GRanges object
}
\description{
Keep distinct ranges by including mcols
}
\details{
Wrapper to \link[dplyr]{distinct} for \code{GRanges} objects.
Finds unique ranges and mcols in combination and retains only
the distinct combinations, in keeping with the \code{dplyr} function.

Will default to \code{unique(granges(x))} if no columns are provided
}
\examples{
gr <- GRanges(rep(c("chr1:1-10"), 2))
gr$id <- paste0("range", seq_along(gr))
gr$gene <- "gene1"
gr
distinctMC(gr)
distinctMC(gr, gene)
distinctMC(gr, gene, .keep_all = TRUE)

}
