% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualityIndices.R
\name{quality}
\alias{quality}
\title{Goodness of classifications.}
\usage{
quality(data, k = 5, cbi = "kmeans", getImages = FALSE,
  all_metrics = FALSE, seed = NULL, ...)
}
\arguments{
\item{data}{A \code{\link{SummarizedExperiment}}.
The SummarizedExperiment must contain an assay with the following structure:
A valid header with names. The first  column of the header is the ID or name
of the instance of the dataset (e.g., ontology, pathway, etc.) on which the
metrics are measured.
The other columns of the header contains the names of the metrics.
The rows contains the measurements of the metrics for each instance in the dataset.}

\item{k}{Positive integer. Number of clusters between [2,15] range.}

\item{cbi}{Clusterboot interface name (default: "kmeans"):
"kmeans", "clara", "clara_pam", "hclust", "pamk", "pamk_pam", "pamk".
Any CBI appended with '_pam' makes use of \code{\link{pam}}.
The method used in 'hclust' CBI is "ward.D2".}

\item{getImages}{Boolean. If true, a plot is displayed.}

\item{all_metrics}{Boolean. If true, clustering is performed upon all the dataset.}

\item{seed}{Positive integer. A seed for internal bootstrap.}
}
\value{
A \code{\link{SummarizedExperiment}} containing the silhouette width measurements and
cluster sizes for cluster \code{k}.
}
\description{
The goodness of the classifications are assessed by validating the clusters
generated. For this purpose, we use the Silhouette width as validity index.
This index computes and compares the quality of the clustering outputs found
by the different metrics, thus enabling to measure the goodness of the
classification for both instances and metrics. More precisely, this goodness measurement
provides an assessment of how similar an instance is to other instances from
the same cluster and dissimilar to all the other clusters. The average on all
the instances quantifies how appropriately the instances are clustered. Kaufman
and Rousseeuw suggested the interpretation of the global Silhouette width score
as the effectiveness of the clustering structure. The values are in the
range [0,1], having the following meaning:

\itemize{
\item There is no substantial clustering structure: [-1, 0.25].
\item The clustering structure is weak and could be artificial: ]0.25, 0.50].
\item There is a reasonable clustering structure: ]0.50, 0.70].
\item A strong clustering structure has been found: ]0.70, 1].
}
}
\examples{
# Using example data from our package
data("ontMetrics")
result = quality(ontMetrics, k=4)

}
\references{
\insertRef{kaufman2009finding}{evaluomeR}
}
