% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{metricsCorrelations}
\alias{metricsCorrelations}
\title{Calculation of Pearson correlation coefficient.}
\usage{
metricsCorrelations(data, margins = c(0, 10, 9, 11), getImages = TRUE)
}
\arguments{
\item{data}{A \code{\link{SummarizedExperiment}}.
The SummarizedExperiment must contain an assay with the following structure:
A valid header with names. The first  column of the header is the ID or name
of the instance of the dataset (e.g., ontology, pathway, etc.) on which the
metrics are measured.
The other columns of the header contains the names of the metrics.
The rows contains the measurements of the metrics for each instance in the dataset.}

\item{margins}{See \code{\link{par}}.}

\item{getImages}{Boolean. If true, a plot is displayed.}
}
\value{
The Pearson correlation matrix as an assay
in a \code{\link{SummarizedExperiment}} object.
}
\description{
Calculation of Pearson correlation coefficient between every pair of
metrics available in order to quantify their interrelationship degree.
The score is in the range [-1,1]. Perfect correlations: -1 (inverse),
and 1 (direct).
}
\examples{
# Using example data from our package
data("ontMetrics")
cor = metricsCorrelations(ontMetrics, getImages = TRUE, margins = c(1,0,5,11))

}
