% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTopElements.R
\name{plotTopElements}
\alias{plotTopElements}
\title{plot top elements for a static plot}
\usage{
plotTopElements(
  packageTextLabel = c("ggrepel", "ggplot2"),
  cex = 1,
  just = c(0.5, 0.5),
  color = "black",
  returnTopElements = FALSE,
  ...
)
}
\arguments{
\item{packageTextLabel}{package used to label the outlying genes/samples/gene sets,
either 'ggrepel' (by default, only used if package \code{ggrepel} is available),
or 'ggplot2'}

\item{cex}{cex of text in the plot}

\item{just}{justification of elements in the plot, only use if \code{packageTextLabel} is 'ggplot2'}

\item{color}{color for the elements in the plot}

\item{returnTopElements}{logical if TRUE (FALSE by default) return the outlying elements}
}
\value{
\itemize{
 \item{if the \code{elements} are present in the data: if \code{returnTopElements} is: }
 \itemize{
   \item{TRUE: }{return a list with two arguments:} 
     \itemize{
      \item{topElements: }{string with top elements labelled in the plot}
      \item{geomText: }{output of \code{geom_text}}
     }
    \item{FALSE: }{only return the output of \code{geom_text}} 
	 }
 \item{if not, return \code{NULL}}
}
}
\description{
This create \code{geom_text} object with top genes/sample/pathways
}
\author{
Laure Cougnaud
}
\keyword{internal}
