% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ground.R, R/add_group_bin.R
\name{add_ground}
\alias{add_ground}
\alias{add_ground_bin}
\title{Adding border to highlight the ground in the spatial map}
\usage{
add_ground(p, var, stroke = 0.5, point_size = 2, ...)

add_ground_bin(p, var, bins = 30, stroke = 1, point_size = 3, ...)
}
\arguments{
\item{p}{a spatial map created by \code{make_escheR()}, with or without other layers of aesthetics.}

\item{var}{A character(1) with the name of the colData(spe) column that has the values to be used as the background.}

\item{stroke}{A numeric(1) specifying the thickness of the border.}

\item{point_size}{A numeric(1) specifying the size of the spot in the ggplot. Defaults to 2.}

\item{...}{Reserved for future arguments.}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}
}
\value{
an ggplot object.
}
\description{
Adding border to highlight the ground in the spatial map
}
\examples{

library(STexampleData)

spe <- Visium_humanDLPFC()

make_escheR(spe) |>
    add_ground(var = "ground_truth")

}
