% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geyserEnrichment.R
\name{geyserEnrichment}
\alias{geyserEnrichment}
\title{Visualize Enrichment Distributions Using Geyser Plots}
\usage{
geyserEnrichment(
  input.data,
  assay = NULL,
  group.by = NULL,
  gene.set,
  color.by = "group",
  order.by = NULL,
  scale = FALSE,
  facet.by = NULL,
  summarise.by = NULL,
  summary.stat = "mean",
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single‑cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Name of the assay holding enrichment scores when
`input.data` is a single‑cell object. Ignored otherwise.}

\item{group.by}{Metadata column plotted on the *x*‑axis.  Defaults to the
Seurat/SCE `ident` slot when `NULL`.}

\item{gene.set}{Character(1). Gene‑set to plot (must exist in the
enrichment matrix).}

\item{color.by}{Aesthetic mapped to point color. Use either
*"group"* (default = `group.by`) for categorical coloring or the
*name of a gene‑set* (e.g. same as `gene.set`) to obtain a numeric
accepted.}

\item{order.by}{How to arrange the x‑axis:
*`"mean"`* – groups ordered by decreasing group mean;
*`"group"`* – natural sort of group labels;
*`NULL`* – keep original ordering.}

\item{scale}{Logical; if `TRUE` scores are centered/scaled (Z‑score) prior
to plotting.}

\item{facet.by}{Optional metadata column used to facet the plot.}

\item{summarise.by}{Optional metadata column used to summarise data.}

\item{summary.stat}{Optional method used to summarize expression within each
group defined by \code{summarise.by}. One of: \code{"mean"} (default),
\code{"median"}, \code{"max"}, \code{"sum"}, or \code{"geometric"}.}

\item{palette}{Character. Any palette from \code{\link[grDevices]{hcl.pals}}.}
}
\value{
A \pkg{ggplot2} object.
}
\description{
This function allows to the user to examine the distribution of 
enrichment across groups by generating a geyser plot.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
           
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs,
            min.size = NULL)

geyserEnrichment(pbmc, 
                 assay = "escape", 
                 gene.set = "Tcells")

}
