% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichItPlot.R
\name{enrichItPlot}
\alias{enrichItPlot}
\title{Adaptive visualisation of enrichIt results}
\usage{
enrichItPlot(
  res,
  plot.type = c("bar", "dot", "cnet"),
  top = 20,
  x.measure = "-log10(padj)",
  color.measure = x.measure,
  show.counts = TRUE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{res}{`data.frame` returned by [enrichIt()].}

\item{plot.type}{`"bar"`, `"dot"`, or `"cnet"`.}

\item{top}{Integer. Keep the top *n* terms **per database**
(ranked by adjusted *p*). Set to `Inf` to keep all.}

\item{x.measure}{A column in `res` mapped to the *x*-axis
(ignored for `"cnet"`). Default `"-log10(padj)"`.}

\item{color.measure}{Column mapped to color (dot plot only).
Default same as `x.measure`.}

\item{show.counts}{Logical. Annotate bar plot with the `Count` (number of genes).}

\item{palette}{palette Character. Any palette from \code{\link[grDevices]{hcl.pals}}.}

\item{...}{Further arguments passed to **ggplot2** geoms (e.g. 
`alpha`, `linewidth`).}
}
\value{
A **patchwork** object (bar / dot) or **ggraph** object (cnet).
}
\description{
Adaptive visualisation of enrichIt results
}
\examples{
\dontrun{
ranks <- setNames(markers$avg_log2FC, rownames(markers))
gs    <- getGeneSets("Homo sapiens", library = c("H", "C2"))
res   <- enrichIt(ranks, gs)

enrichItPlot(res)               
enrichItPlot(res, "dot", top=10) 
enrichItPlot(res, "cnet", top=5) 
}
}
