% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnzipAndMerge.R
\name{UnzipAndMerge}
\alias{UnzipAndMerge}
\alias{atacUnzipAndMerge}
\alias{unzipAndMerge}
\title{Unzip and merge fastq files}
\usage{
atacUnzipAndMerge(
  fastqInput1,
  fastqInput2 = NULL,
  fastqOutput1 = NULL,
  fastqOutput2 = NULL,
  interleave = FALSE,
  ...
)

unzipAndMerge(
  fastqInput1,
  fastqInput2 = NULL,
  fastqOutput1 = NULL,
  fastqOutput2 = NULL,
  interleave = FALSE,
  ...
)
}
\arguments{
\item{fastqInput1}{\code{Character} vector. For single-end sequencing,
it contains sequence file paths.
For paired-end sequencing, it can be file paths with #1 mates paired
with file paths in fastqInput2
And it can also be interleaved file paths when argument
interleaved=\code{TRUE}}

\item{fastqInput2}{\code{Character} vector. It contains file paths with #2
mates paired with file paths in fastqInput1
For single-end sequencing files and interleaved paired-end sequencing
files(argument interleaved=\code{TRUE}),
it must be \code{NULL}.}

\item{fastqOutput1}{\code{Character}. The trimmed mate1 reads output file
path for fastqInput2.}

\item{fastqOutput2}{\code{Character}. The trimmed mate2 reads output file
path for fastqInput2.}

\item{interleave}{\code{Logical}. Set \code{TRUE} when files are
interleaved paired-end sequencing data.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
Unzip and merge fastq files that are in format of bzip, gzip or fastq
}
\examples{

ignoreCheck() # warnning: run this for fast test only

td<-tempdir()
setTmpDir(td)

# Identify adapters
prefix<-system.file(package="esATAC", "extdata", "uzmg")
(reads_1 <-file.path(prefix,"m1",dir(file.path(prefix,"m1"))))
(reads_2 <-file.path(prefix,"m2",dir(file.path(prefix,"m2"))))

reads_merged_1 <- file.path(td,"reads_1.fq")
reads_merged_2 <- file.path(td,"reads_2.fq")
atacproc <- atacUnzipAndMerge(fastqInput1 = reads_1,fastqInput2 = reads_2)
dir(td)

}
\seealso{
\code{\link{atacRenamer}}
\code{\link{atacQCReport}}
}
\author{
Zheng Wei
}
