% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Renamer.R
\name{Renamer}
\alias{Renamer}
\alias{atacRenamer,ATACProc-method}
\alias{atacRenamer}
\alias{renamer}
\title{Rename reads name in fastq}
\usage{
atacRenamer(
  atacProc,
  fastqOutput1 = NULL,
  fastqOutput2 = NULL,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  ...
)

\S4method{atacRenamer}{ATACProc}(
  atacProc,
  fastqOutput1 = NULL,
  fastqOutput2 = NULL,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  ...
)

renamer(
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  fastqOutput1 = NULL,
  fastqOutput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacUnzipAndMerge}}
\code{\link{unzipAndMerge}}}

\item{fastqOutput1}{\code{Character} scalar.
The output file path of renamed fastqInput1.}

\item{fastqOutput2}{\code{Character} scalar.
The output file path of renamed fastqInput2.}

\item{fastqInput1}{\code{Character} scalar. For single-end sequencing,
it contains sequence file paths.
For paired-end sequencing, it can be file path with #1 mates paired
with file path in file2
And it can also be interleaved file paths when argument
interleave=\code{TRUE}}

\item{fastqInput2}{\code{Character} scalar. It contains file path with #2
mates paired with file paths in fastqInput1
For single-end sequencing files and interleaved paired-end sequencing
files(argument interleaved=\code{TRUE}),
it must be \code{NULL}.}

\item{interleave}{\code{Character} scalar.
Set \code{TRUE} when files are
interleaved paired-end sequencing data.}

\item{threads}{\code{Integer} scalar.
The threads will be created in this process. default: 1}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
Rename reads name in fastq with increasing integer
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{renamer} instead.
}
\examples{

ignoreCheck() # warnning: run this for fast test only
library(magrittr)
td <- tempdir()
setTmpDir(td)

# Identify adapters
prefix<-system.file(package="esATAC", "extdata", "uzmg")
(reads_1 <-file.path(prefix,"m1",dir(file.path(prefix,"m1"))))
(reads_2 <-file.path(prefix,"m2",dir(file.path(prefix,"m2"))))

reads_merged_1 <- file.path(td,"reads1.fastq")
reads_merged_2 <- file.path(td,"reads2.fastq")
atacproc <-
atacUnzipAndMerge(fastqInput1 = reads_1,fastqInput2 = reads_2) \%>\%
atacRenamer

dir(td)

}
\seealso{
\code{\link{atacUnzipAndMerge}}
\code{\link{unzipAndMerge}}
\code{\link{atacQCReport}}
\code{\link{atacRemoveAdapter}}
}
\author{
Zheng Wei
}
