% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPeakComp.R
\name{RPeakComp}
\alias{RPeakComp}
\alias{atacPeakComp,ATACProc-method}
\alias{atacPeakComp}
\alias{peakcomp}
\title{Find the overlap or differential peaks between two samples.}
\usage{
atacPeakComp(
  atacProcPeak1,
  atacProcPeak2,
  bedInput1 = NULL,
  bedInput2 = NULL,
  bedOutput = NULL,
  olap.rate = 0.2,
  ...
)

\S4method{atacPeakComp}{ATACProc}(
  atacProcPeak1,
  atacProcPeak2,
  bedInput1 = NULL,
  bedInput2 = NULL,
  bedOutput = NULL,
  olap.rate = 0.2,
  ...
)

peakcomp(
  bedInput1 = NULL,
  bedInput2 = NULL,
  bedOutput = NULL,
  olap.rate = 0.2,
  ...
)
}
\arguments{
\item{atacProcPeak1}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacPeakCalling}}.}

\item{atacProcPeak2}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacPeakCalling}}.}

\item{bedInput1}{\code{Character} scalar.
Input peak file path. UCSC bed file is recommented. Other file should be
able to import as \code{\link{GRanges}} objects through
 \code{import} in package rtracklayer.}

\item{bedInput2}{\code{Character} scalar.
Input peak file path. UCSC bed file is recommented. Other file should be
able to import as \code{\link{GRanges}} objects through
 \code{import} in package rtracklayer.}

\item{bedOutput}{The output file path for overlap peaks.}

\item{olap.rate}{Overlap rate, if the overlap region between 2 peak is more
than this rate of the short peak, these two peak are considered to be
overlap and will be merged to a bigger peak. Default: 0.2. NOTICE: multi-peak will be
merged together!}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for
downstream analysis.
}
\description{
This function compares two peak file and report overlap or differential peaks
according to the parameter "operation".
}
\examples{

library(R.utils)
p1bz <- system.file("extdata", "Example_peak1.bed.bz2", package="esATAC")
p2bz <- system.file("extdata", "Example_peak2.bed.bz2", package="esATAC")
\dontrun{
peak1_path <- as.vector(bunzip2(filename = p1bz,
destname = file.path(getwd(), "Example_peak1.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE , remove = FALSE))
peak2_path <- as.vector(bunzip2(filename = p2bz,
destname = file.path(getwd(), "Example_peak2.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
output <- peakcomp(bedInput1 = peak1_path, bedInput2 = peak2_path,
olap.rate = 0.1)
}
}
\seealso{
\code{\link{atacPeakCalling}}
}
\author{
Wei Zhang
}
