% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RGo.R
\name{RGo}
\alias{RGo}
\alias{atacGOAnalysis,ATACProc-method}
\alias{atacGOAnalysis}
\alias{goanalysis}
\title{Gene Ontology Analysis}
\usage{
atacGOAnalysis(
  atacProc,
  gene = NULL,
  OrgDb = NULL,
  keytype = "ENTREZID",
  ont = "MF",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe = NULL,
  qvalueCutoff = 0.2,
  readable = FALSE,
  pool = FALSE,
  goOutput = NULL,
  ...
)

\S4method{atacGOAnalysis}{ATACProc}(
  atacProc,
  gene = NULL,
  OrgDb = NULL,
  keytype = "ENTREZID",
  ont = "MF",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe = NULL,
  qvalueCutoff = 0.2,
  readable = FALSE,
  pool = FALSE,
  goOutput = NULL,
  ...
)

goanalysis(
  gene,
  OrgDb = NULL,
  keytype = "ENTREZID",
  ont = "MF",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe = NULL,
  qvalueCutoff = 0.2,
  readable = FALSE,
  pool = FALSE,
  goOutput = NULL,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacPeakAnno}}.}

\item{gene}{A vector of entrez gene id.}

\item{OrgDb}{Genome wide annotation databese.}

\item{keytype}{Keytype of input gene.}

\item{ont}{One of "MF", "BP", and "CC" subontologies.
"MF" for molecular function,
"BP" for biological process, "CC" for cellular component.}

\item{pvalueCutoff}{pvalueCutoff.}

\item{pAdjustMethod}{One of "holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr", "none".}

\item{universe}{Background genes.}

\item{qvalueCutoff}{qvalue cutoff.}

\item{readable}{whether mapping gene ID to gene Name.}

\item{pool}{If ont=’ALL’, whether pool 3 GO sub-ontologies.}

\item{goOutput}{\code{Character} scalar.
Output file path. Defult:in the same folder as your input file with the
suffix "df".}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar.
}
\description{
Ranking functional groups based on a set of genes. For more information,
please see \link[clusterProfiler]{enrichGO}.
}
\details{
This function using \link[clusterProfiler]{enrichGO} to do GO
analysis but fixed some parameters. If atacProc is not NULL, it will read
the gene ID from the output of \code{\link{atacPeakAnno}}.
}
\examples{

\dontrun{
library(org.Hs.eg.db)
# generate simulated geneID
geneId <- as.character(sample(seq(10000), 100))
goanalysis(gene = geneId, OrgDb = 'org.Hs.eg.db')
}

}
\references{
Guangchuang Yu., Li-Gen Wang, Yanyan Han, Qing-Yu He.
clusterProfiler: an R package for comparing biological themes among gene
clusters. OMICS: A Journal of Integrative Biology. 2012, 16(5):284-287
}
\seealso{
\code{\link{atacPeakAnno}}
\link[clusterProfiler]{enrichGO} function enrichGO in package
"clusterProfiler"
}
\author{
Wei Zhang
}
