% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FregLenDistribute.R
\name{FragLenDistr}
\alias{FragLenDistr}
\alias{atacFragLenDistr,ATACProc-method}
\alias{atacFragLenDistr}
\alias{fragLenDistr}
\title{Quality control for fragment length distribution}
\usage{
atacFragLenDistr(atacProc, reportPrefix = NULL, bedInput = NULL, ...)

\S4method{atacFragLenDistr}{ATACProc}(atacProc, reportPrefix = NULL, bedInput = NULL, ...)

fragLenDistr(bedInput, reportPrefix = NULL, ...)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacSamToBed}}
\code{\link{samToBed}}
\code{\link{atacBedUtils}}
\code{\link{bedUtils}}}

\item{reportPrefix}{\code{Character} scalar.
The prefix of report files path.}

\item{bedInput}{\code{Character} scalar.
BED file input path.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
These functions are used to generate fragment distribution plot.
The fourier transform of fragment distribution will be calculated.
Strength distribution around period at 10.4bp and 180bp
will be shown in another two plots.
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{fragLenDistr} instead.
}
\examples{

library(R.utils)
td <- tempdir()
setTmpDir(td)

bedbzfile <- system.file(package="esATAC", "extdata", "chr20.50000.bed.bz2")
bedfile <- file.path(td,"chr20.50000.bed")
\dontrun{
bunzip2(bedbzfile,destname=bedfile,overwrite=TRUE,remove=FALSE)
fragLenDistr(bedfile)
}

dir(td)

}
\seealso{
\code{\link{atacSamToBed}}
\code{\link{samToBed}}
\code{\link{atacBedUtils}}
\code{\link{bedUtils}}
}
\author{
Zheng Wei
}
