% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BedUtils.R
\name{BedUtils}
\alias{BedUtils}
\alias{atacBedUtils,ATACProc-method}
\alias{atacBedUtils}
\alias{bedUtils}
\title{process bed file with limit memory}
\usage{
atacBedUtils(
  atacProc,
  bedInput = NULL,
  bedOutput = NULL,
  mergePair = FALSE,
  downSample = NULL,
  posOffset = 0L,
  negOffset = 0L,
  chrFilterList = c("chrM"),
  select = FALSE,
  sortBed = FALSE,
  uniqueBed = FALSE,
  minFragLen = 0,
  maxFragLen = 2e+09,
  newStepType = "BedUtils",
  ...
)

\S4method{atacBedUtils}{ATACProc}(
  atacProc,
  bedInput = NULL,
  bedOutput = NULL,
  mergePair = FALSE,
  downSample = NULL,
  posOffset = 0L,
  negOffset = 0L,
  chrFilterList = c("chrM"),
  select = FALSE,
  sortBed = FALSE,
  uniqueBed = FALSE,
  minFragLen = 0,
  maxFragLen = 2e+09,
  newStepType = "BedUtils",
  ...
)

bedUtils(
  bedInput,
  bedOutput = NULL,
  mergePair = FALSE,
  downSample = NULL,
  reportOutput = NULL,
  posOffset = 0L,
  negOffset = 0L,
  chrFilterList = c("chrM"),
  select = FALSE,
  sortBed = FALSE,
  uniqueBed = FALSE,
  minFragLen = 0,
  maxFragLen = 2e+09,
  newStepType = "BedUtils",
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacBam2Bed}}
\code{\link{bam2bed}}
\code{\link{atacSamToBed}}
\code{\link{samToBed}}}

\item{bedInput}{\code{Character} scalar.
Bed file input path.}

\item{bedOutput}{\code{Character} scalar.
Bed file output path.}

\item{mergePair}{\code{Logical} scalar
Merge paired end interleave reads.}

\item{downSample}{\code{Integer} scalar
Down sample reads if the number is less than total number}

\item{posOffset}{\code{Integer} scalar
The offset that positive strand reads will shift.}

\item{negOffset}{\code{Integer} scalar
The offset that negative strand reads will shift.}

\item{chrFilterList}{\code{Character} vector
The chromatin(or regex of chromatin) will be retain/discard
if \code{select} is TRUE/FALSE}

\item{select}{\code{Logical} scalar
The chromatin in \code{chrFilterList} will be retain if TRUE. default: FALSE}

\item{sortBed}{\code{Logical} scalar
Sort bed file in the order of chromatin, start, end}

\item{uniqueBed}{\code{Logical} scalar
Remove duplicates reads in bed if TRUE. default: FALSE}

\item{minFragLen}{\code{Integer} scalar
The minimum fragment size will be retained.}

\item{maxFragLen}{\code{Integer} scalar
The maximum fragment size will be retained.}

\item{newStepType}{\code{Character} scalar.
New step type name for different default parameters.}

\item{...}{Additional arguments, currently unused.}

\item{reportOutput}{\code{Character} scalar.
Report output file path.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
This function is used to
merge interleave paired end reads in bed,
downsample bed reads,
shift bed reads,
filter bed reads according to chromosome,
filter bed reads according to fragment size,
sort bed,
remove duplicates reads in bed.
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{bedUtils} instead.
}
\examples{
library(R.utils)
library(magrittr)
td <- tempdir()
setTmpDir(td)

sambzfile <- system.file(package="esATAC", "extdata", "Example.sam.bz2")
samfile <- file.path(td,"Example.sam")
bunzip2(sambzfile,destname=samfile,overwrite=TRUE,remove=FALSE)
atacproc<-samToBed(samInput = samfile) \%>\%
atacBedUtils(maxFragLen = 100, chrFilterList = NULL)

}
\seealso{
\code{\link{atacBam2Bed}}
\code{\link{bam2bed}}
\code{\link{atacSamToBed}}
\code{\link{samToBed}}
\code{\link{atacFragLenDistr}}
\code{\link{atacExtractCutSite}}
\code{\link{atacPeakCalling}}
\code{\link{atacTSSQC}}
\code{\link{atacBedToBigWig}}
}
\author{
Zheng Wei
}
