% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BamToBed.R
\name{BamToBed}
\alias{BamToBed}
\alias{atacBam2Bed,ATACProc-method}
\alias{atacBam2Bed}
\alias{bam2bed}
\title{Convert bam format to bed format.}
\usage{
atacBam2Bed(
  atacProc,
  bamInput = NULL,
  bedOutput = NULL,
  reportOutput = NULL,
  bsgenome = NULL,
  mergePairIntoFrag = c("auto", "yes", "no"),
  posOffset = +4,
  negOffset = -5,
  chrFilterList = "chrM|_",
  sortBed = TRUE,
  rmMultiMap = TRUE,
  minFragLen = 0,
  maxFragLen = 2000,
  saveExtLen = FALSE,
  uniqueBed = c("auto", "yes", "no"),
  ...
)

\S4method{atacBam2Bed}{ATACProc}(
  atacProc,
  bamInput = NULL,
  bedOutput = NULL,
  reportOutput = NULL,
  bsgenome = NULL,
  mergePairIntoFrag = c("auto", "yes", "no"),
  posOffset = +4,
  negOffset = -5,
  chrFilterList = "chrM|_",
  sortBed = TRUE,
  rmMultiMap = TRUE,
  minFragLen = 0,
  maxFragLen = 2000,
  saveExtLen = FALSE,
  uniqueBed = c("auto", "yes", "no"),
  ...
)

bam2bed(
  bamInput,
  bedOutput = NULL,
  reportOutput = NULL,
  bsgenome = NULL,
  mergePairIntoFrag = c("auto", "yes", "no"),
  posOffset = +4,
  negOffset = -5,
  chrFilterList = "chrM|_",
  sortBed = TRUE,
  rmMultiMap = TRUE,
  minFragLen = 0,
  maxFragLen = 2000,
  saveExtLen = FALSE,
  uniqueBed = c("auto", "yes", "no"),
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacBamSort}},
\code{\link{atacSam2Bam}}.}

\item{bamInput}{\code{Character} scalar.
Bam file input path.}

\item{bedOutput}{\code{Character} scalar.
Bed file output path. If ignored, bed file will be put in the same path as
the bam file.}

\item{reportOutput}{\code{Character} scalar.
Report file path.}

\item{bsgenome}{\code{BSgenome} object.
This object from bioconductor}

\item{mergePairIntoFrag}{\code{Logical} scalar
Merge paired end reads.}

\item{posOffset}{\code{Integer} scalar
The offset that positive strand reads will shift.}

\item{negOffset}{\code{Integer} scalar
The offset that negative strand reads will shift.}

\item{chrFilterList}{\code{Character} vector
The chromatin(or regex of chromatin) will be discard}

\item{sortBed}{\code{Logical} scalar
Sort bed file in the order of chromatin, start, end}

\item{rmMultiMap}{\code{Logical} scalar.
Remove multi-map reads.}

\item{minFragLen}{\code{Integer} scalar
The minimum fragment size will be retained.}

\item{maxFragLen}{\code{Integer} scalar
The maximum fragment size will be retained.}

\item{saveExtLen}{\code{Logical} scaler.
Save the fragment that are not in the range of minFragLen and maxFragLen}

\item{uniqueBed}{\code{Logical} scalar
Remove duplicates reads in bed if TRUE. default: FALSE}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for
downstream analysis.
}
\description{
This function is used to convert SAM file to BED file and
merge interleave paired end reads,
shift reads,
filter reads according to chromosome,
filter reads according to fragment size,
sort,
remove duplicates reads before generating BED file.
}
\details{
The bam file wiil be automatically obtained from
object(\code{atacProc}) or input by hand. Output can be ignored.
}
\examples{

library(Rsamtools)
# change dataset !!
# ex1_file <- system.file("extdata", "ex1.bam", package="Rsamtools")
# bam2bed(bamInput = ex1_file)

}
\seealso{
\code{\link{atacBamSort}}
\code{\link{atacSam2Bam}}
}
\author{
Zheng Wei, Wei Zhang
}
