% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizApp-class.R
\docType{class}
\name{EpivizApp-class}
\alias{EpivizApp-class}
\alias{EpivizApp}
\title{Class managing connection to epiviz application.}
\description{
Class managing connection to epiviz application.
}
\section{Fields}{

\describe{
\item{\code{server}}{An object of class \code{\link{EpivizServer}} used to communicate with epiviz app.}

\item{\code{data_mgr}}{An object of class \code{\link{EpivizDataMgr}} used to serve data to epiviz app.}

\item{\code{chart_mgr}}{An object of class \code{\link{EpivizChartMgr}} used to manage charts added to epiviz app session.}
}}

\section{Methods}{

\describe{
\item{\code{get_current_location(callback)}}{Obtain current genome location on epiviz app and evaluate callback
function on result.

\describe{
  \item{callback}{A callback function to evaluate on response data. 
    Response data will be a list with slots \code{seqName}, \code{start}
    and \code{end}}
}}

\item{\code{get_ms_object(chart_id_or_object, index = 1)}}{Get object of class \code{\link[epivizrData]{EpivizData}} used as a data source
in a given chart.

\describe{
  \item{chart_id_or_object}{An object of class \code{EpivizChart} or an id for
    a chart loaded to the epiviz app.}
  \item{index}{Index into \code{.measurements}} list of chart object to obtain data object for.
}}

\item{\code{is_server_closed()}}{Check if underlying server connection is closed.}

\item{\code{load_remote_measurements()}}{Load remote measurements into R session.}

\item{\code{load_workspace(workspace_id = NULL)}}{load an epiviz workspace.

    \describe{
      \item{workspace_id}{Workspace id to load from the database.}
    }}

\item{\code{navigate(chr, start, end)}}{Navigate to given position on the epiviz app.}

\item{\code{plot(
  data_object,
  datasource_name = NULL,
  send_request = TRUE,
  settings = NULL,
  colors = NULL,
  ...
)}}{Visualize data on epiviz app using its default chart type. Measurements from the \code{data-object} 
are first added to the epiviz app using the \code{add_measurements} method for class 
\code{\link[epivizrData]{EpivizData}}. See documentation for \code{\link[epivizrData]{register}}
for information on supported data types and the \code{\link[epivizrData]{EpivizData}} class
encapsulating this type of data. Once measurements are loaded, the \code{\link{plot}} method
of class \code{\link{EpivizChartMgr}} is used to plot the data, using the default chart type
for this type of data.

\describe{
  \item{data_object}{An object to plot in epiviz app.}
  \item{datasource_name}{Name to use for datasource, parses \code{data_object} if missing or NULL}
  \item{...}{Additional arguments passed to \code{add_measurements} method for class
    \code{\link[epivizrData]{EpivizData}}}
}}

\item{\code{print_workspace(file_name = NULL, file_type = "pdf")}}{Save epiviz workspace as a pdf or png.}

\item{\code{save(file, include_data = TRUE)}}{Save EpivizApp object representation of a workspace into .RData file.

    \describe{
      \item{file}{(character) The name of the file to save the EpivizApp object into, ending in .rda.}
      \item{stop_app}{(logical) Stop the EpivizApp session.}
      \item{include_data}{(logical) Include EpivizApp's data when saving the EpivizApp object.}
    }}

\item{\code{service(verbose = TRUE)}}{Block interactive R session to service websocket requests.}

\item{\code{slideshow(granges, n = length(granges), .callback = NULL)}}{Navigate on epiviz app successively to given positions.

\describe{
  \item{granges}{An object of class \code{\link{GenomicRanges}} indicating
    set of genomic regions to navigate in epiviz app.}
  \item{n}{(integer) The number of regions in \code{granges} to navigate to.}
  \item{.callback}{(function) function to call after navigating to each region. Used for testing purposes.}
}}

\item{\code{stop_app()}}{stop and clean connection to epiviz app.}
}}

