% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMetricAndArrangeRSE.R
\name{addMetricAndArrangeRSE}
\alias{addMetricAndArrangeRSE}
\title{addMetricAndArrangeRSE()}
\usage{
addMetricAndArrangeRSE(
  rse,
  order,
  rse_key = "name",
  order_key = "name",
  order_value = "exp",
  shuffle_tie = TRUE
)
}
\arguments{
\item{rse}{a rangedSummarizedExperiment object.}

\item{order}{a data.frame with at least two columns: keys and values.}

\item{rse_key}{name of the gr metadata column containing unique names for
each genomic region in \code{rowRanges(rse)}. Usually gene names/id or
peak id.}

\item{order_key}{name of the \code{order} column
that will be used as key for the inner join.}

\item{order_value}{name of the \code{order} column
that contain value used for sorting.}

\item{shuffle_tie}{a boolean Value (TRUE / FALSE).
When TRUE, shuffle the GRanges before sorting, mixing the ties.}
}
\value{
a rangedSummarizedExperiment sorted in descending order.
}
\description{
Perform an inner join between a rangedSummarizedExperiment object
and a data.frame. Sort
the resulting rangedSummarizedExperiment based on a metric column.
}
\details{
This utility function allow the addition of a metric column to
genomic regions of interest. One of its common use case is to add
gene expression values on a set of transcription start sites.
The resulting GRanges object will only contain regions presents in both
\code{rse} and \code{order}.
}
\examples{
data("stackepi")
ramdomOrder <- data.frame(
   gene_id = SummarizedExperiment::rowRanges(stackepi)$gene_id,
   value = rnorm(length(stackepi))
)
addMetricAndArrangeRSE(stackepi,
   ramdomOrder, rse_key = "gene_id",
   order_key = "gene_id", order_value = "value")


}
