% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotHeatmapActivity}
\alias{plotHeatmapActivity}
\title{Plot transcription factor activity}
\usage{
plotHeatmapActivity(
  activity_matrix,
  sce,
  tfs,
  downsample = 1000,
  scale = TRUE,
  center = TRUE,
  color_breaks = c(-2, 0, 2),
  colors = c("blue", "white", "red"),
  cell_attributes = NULL,
  col_gap = NULL,
  use_raster = TRUE,
  raster_quality = 10,
  cluster_rows = TRUE,
  cluster_columns = FALSE,
  border = TRUE,
  show_column_names = FALSE,
  ...
)
}
\arguments{
\item{activity_matrix}{A matrix of values, such as TF activities inferred from calculateActivity}

\item{sce}{A SingleCellExperiment object containing information of cell attributes}

\item{tfs}{A character vector indicating the names of the transcription factors to be plotted}

\item{downsample}{Integer indicating the number of cells to sample from the matrix}

\item{scale}{Logical indicating whether to scale the heatmap}

\item{center}{Logical indicating whether to center the heatmap}

\item{color_breaks}{A vector indicating numeric breaks as input to \code{circlize::colorRamp2}}

\item{colors}{A vector of colors corresponding to values in \code{breaks} as input to \code{circlize::colorRamp2}}

\item{cell_attributes}{A character vector matching the column names of \code{colData(sce)} to be used for plotting}

\item{col_gap}{String indicating the cell attribute to split the columns of the heatmap by}

\item{use_raster}{Logical indicating whether to use rasterization to reduce image size}

\item{raster_quality}{Integer indicating the raster quality. The higher the value, the better the resolution}

\item{cluster_rows}{Logical indicating whether to cluster rows}

\item{cluster_columns}{Logical indicating whether to cluster columns}

\item{border}{Logical indicating whether to add border around heatmap}

\item{show_column_names}{Logical indicating whether to show column names}

\item{...}{other arguments for \code{ComplexHeatmap::Heatmap}}
}
\value{
A Heatmap-class object.
}
\description{
Plot transcription factor activity
}
\examples{
example_sce <- scuttle::mockSCE()
example_sce <- scuttle::logNormCounts(example_sce)
example_sce$cluster <- sample(LETTERS[1:5], ncol(example_sce), replace = TRUE)
activity_matrix <- matrix(rnorm(10*200), nrow=10, ncol=200)
rownames(activity_matrix) <- sample(rownames(example_sce),10)
plotHeatmapActivity(activity_matrix=activity_matrix, sce=example_sce,
tfs=rownames(activity_matrix), cell_attributes='cluster', col_gap='cluster')
}
\author{
Xiaosai Yao
}
