% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulonSimilarities.R
\name{calculateJaccardSimilarity}
\alias{calculateJaccardSimilarity}
\title{Calculate Jaccard Similarity between regulons of all transcription factors}
\usage{
calculateJaccardSimilarity(graph)
}
\arguments{
\item{graph}{a igraph object from \code{buildGraph} or \code{buildDiffGraph}}
}
\value{
A matrix with Jaccard similarity between all pairs of transcription factors.
}
\description{
Calculate Jaccard Similarity between regulons of all transcription factors
}
\examples{
regulon <- data.frame(tf = sample(letters[1:4], 100, replace = TRUE), idxATAC= 1:100,
target = sample(letters[5:14], 100, replace = TRUE))
regulon$weights <- runif(100)
GRN_graph <- buildGraph(regulon)
similarity <- calculateJaccardSimilarity(GRN_graph)
}
