% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_epimutations.R
\name{annotate_epimutations}
\alias{annotate_epimutations}
\title{Annotate the results of  epimutations or
epimutations_one_leave_out functions}
\usage{
annotate_epimutations(
  epi_results,
  db = "IlluminaHumanMethylationEPICanno.ilm10b2.hg19",
  build = "37",
  ...
)
}
\arguments{
\item{epi_results}{a data frame object containing the output
from \code{epimutations} or
\code{epimutations_one_leave_out} functions.}

\item{db}{a character string containing
the Illumina annotation package
used to annotate the CpGs.}

\item{build}{a character string containing the genomic
build where the epimutations are mapped.
The default is GRCh37 (\code{build = "37"}). To use GRCh38
set \code{built} to \code{NULL}.}

\item{...}{Further arguments passed to \code{annotate_cpg}.}
}
\value{
The function returns the
input object \code{epi_results}
with additional columns containing the  information about
the genes or overlapping regulatory features.

See \link[epimutacions]{annotate_cpg} and
\link[epimutacions]{add_ensemble_regulatory}
for an in-depth description of these variables.
}
\description{
Information about close genes and regulatory
elements for epimutations.
}
\examples{

data(res.epi.manova)
#Annotate the epimutations

#anno_results <- annotate_epimutations(res.epi.manova)

}
