\name{normalizeChIP}
\alias{normalizeChIP}
\alias{normalizeChIP,ChIPseqSet,character-method}

\title{
  Normalization of ChIP-seq count data. (deprecated)
}

\description{
  This method is deprecated. Use normalize instead.
  This method implements some normalization approaches for
  ChIP-seq data after counting reads within regions or bins. Similar
  methods are often applied to RNA-seq data after counting reads within
  genes.
}

\usage{
normalizeChIP(object, method)
}

\arguments{
  \item{object}{
    A \code{\linkS4class{ChIPseqSet}} object as generated by
    \code{\link{summarizeReads}}
  }
  \item{method}{
    Normalization method, either "scaleTotal", "scaleRegion",
    "scaleMedianRegion" or "quantile"
  }
}

\details{
  The following normalization methods are implemented:
  \enumerate{
    \item{scaleTotal}{Samples are scaled by a factor such that all samples
      have the same number of reads (the median number of reads observed
      accross all samples before normalization). All reads are used for
      calculating the scaling factor.}
    \item{scaleRegion}{Samples are scaled by a factor such that all samples
      have the same number of reads (the median number of reads observed
      accross all samples before normalization). In contrast to scaleTotal,
      only reads falling into the regions (genes, promoters) that were used
      to create the given \code{\linkS4class{ChIPseqSet}} object are used for
      calculating the scaling factor. Hence, the sum of all columns of the
      returned \code{\linkS4class{ChIPseqSet}} are equal after applying this
      method.}
    \item{scaleMedianRegion}{The scaling factor \eqn{s_j} for the
      \eqn{j}-th sample is defined as:
      \deqn{s_j = median_i \frac{k_{ij}}{\prod_{v=1}^m k_{iv}}}
      \eqn{k_{ij}} is the value of region \eqn{i} in sample
      \eqn{j}. See Anders and Huber (2010) for details.}
    \item{quantile}{Quantile normalization is applied to the ChIP-seq
      values such that each sample has the same cdf after normalization.}
  }
}

\value{
  An \code{\link{ChIPseqSet-class}} object with normalized ChIP-seq
  values.
}

\seealso{
  \code{\link{summarizeReads}}
}

\references{
  Anders and Huber; Differential expression analysis for sequence count
  data; Genome Biology 2010, 11:R106
}

\author{
  Hans-Ulrich Klein (h.klein@uni-muenster.de
}

\examples{
  chip <- matrix(c(5,6,5,6,10,12,10,12), nrow=4,
                 dimnames=list(c("f1", "f2", "f3", "f4"), c("s1", "s2")))
  rowRanges <- GRanges(IRanges(start=c(10, 20, 30, 40), end=c(11, 21, 31, 41)),
                     seqnames=c("1", "1", "1", "1"))
  names(rowRanges) = rownames(chip)
  chipDf <- DataFrame(totalCount=c(100, 100),
                      row.names=colnames(chip))
  cSet <- ChIPseqSet(chipVals=chip, rowRanges=rowRanges, colData=chipDf)

  chipVals(cSet)
  chipVals(normalize(cSet, method="scaleMedianRegion"))
  chipVals(normalize(cSet, method="quantile"))
}
