% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{rank.enrichment}
\alias{rank.enrichment}
\title{Rank enrichment}
\usage{
rank.enrichment(
  data,
  list,
  list2 = NULL,
  n = 1000,
  main = NULL,
  col1 = "RdBu",
  col2 = rgb(1, 0, 0, 0.75),
  col3 = rgb(0, 0, 1, 0.75),
  blim = NULL,
  p = NULL,
  lwd = 3,
  test = wilcox.test,
  vis = "matrix",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{m times l matrix with m observed genes and l
variables with numeric values to rank the genes}

\item{list}{list of of vectors of genes}

\item{list2}{optional list with same length as list}

\item{n}{length of the gradient (maximum: m)}

\item{main}{character string for main header; if NULL uses
the column names of data by default}

\item{col1}{color of the gradient}

\item{col2}{color of the first list}

\item{col3}{color of the second list2}

\item{blim}{numeric vector of length two with the lower
and upper bounds for the gradient}

\item{p}{numeric adjustment (length four) of the left side of the
gradient (low means more to the left, high more to the right)
the right side of the enrichment lines and the top positions
of the additional matrices in case of vis='matrices'}

\item{lwd}{line width of the enrichment lines}

\item{test}{test function for the enrichment p-value; must
have input argument and output values same as perm.rank.test;
e.g., wilcox.test or ks.test (here 'less' and 'greater' are switched!)}

\item{vis}{method for visualisation: 'matrix' uses one
matrix heatmap for; 'matrices' uses several matrices
(experimental), 'colside'
uses the colSideColors argument for the ticks of genes in
list/list2 (can use a lot of memory; experimental)}

\item{verbose}{if TRUE gives prints additional output}

\item{...}{additional arguments for epiNEM::HeatmapOP}
}
\value{
transitively closed matrix or graphNEL
}
\description{
Infers a signalling pathway from peerturbation experiments.
}
\examples{
data <- matrix(rnorm(100*2),100,2)
rownames(data) <- 1:100
colnames(data) <- LETTERS[1:2]
list <- list(first = as.character(sample(1:100, 10)), second = as.character(sample(1:100, 20)))
rank.enrichment(data,list)
}
\author{
Martin Pirkl
}
