% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsInternal.R
\encoding{UTF-8}
\name{filterResults}
\alias{filterResults}
\title{Filter the results to retain only the selected terms}
\usage{
filterResults(gostResults, source, termIDs, removeRoot)
}
\arguments{
\item{gostResults}{a \code{data.frame} containing the enriched terms that 
should be filtered.}

\item{source}{a \code{character} string representing the selected source 
that will be used to generate the network. To hand-pick the terms to be 
used, "TERM_ID" should be used and the list of selected term IDs should
be passed through the \code{termIDs} parameter. The possible sources are 
"GO:BP" for Gene Ontology Biological Process, "GO:CC" for Gene Ontology  
Cellular Component, "GO:MF" for Gene Ontology Molecular Function, 
"KEGG" for Kegg, "REAC" for Reactome, "TF" for TRANSFAC, "MIRNA" for 
miRTarBase, "CORUM" for CORUM database, "HP" for Human phenotype ontology
and "WP" for WikiPathways.}

\item{termIDs}{a \code{vector} of \code{character} strings that contains the
term IDS retained for the creation of the network or \code{NULL}.}

\item{removeRoot}{a \code{logical} that specified if the root terms of 
the selected source should be removed (when present).}
}
\value{
a \code{data.frame} of filtered terms with or without the root term.
}
\description{
Filter the enrichment results to retain only the selected 
terms and remove root term if requested.
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(demoGOST)

## Only retained the GO - Molecular Function results
results <- demoGOST$result

## Remove WIKIPATHWAYS root term
selected <- enrichViewNet:::filterResults(gostResults=results, source="WP", 
    termIDs=NULL, removeRoot=TRUE)


}
\author{
Astrid Deschênes
}
\keyword{internal}
