% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsInternal.R
\encoding{UTF-8}
\name{extractNodesAndEdgesInformation}
\alias{extractNodesAndEdgesInformation}
\title{Extract node and edge information from the enrichment results}
\usage{
extractNodesAndEdgesInformation(gostResults, gostObject)
}
\arguments{
\item{gostResults}{a \code{data.frame} containing the terms retained
for the creation of the network. The \code{data.frame} does not contain a
column called "intersection".}

\item{gostObject}{a \code{list} created by gprofiler2 that contains
the results from an enrichment analysis.}
}
\value{
\code{list} containing 2 entries:
\itemize{
\item{\code{"geneNodes"}: a \code{data.frame} containing the information 
about the nodes present in the network. The nodes are genes.}
\item{\code{"termNodes"}: a \code{data.frame} containing the information 
about the nodes present in the network. The nodes are terms.}
\item{\code{"edges"}: a \code{data.frame} containing the information about
the edges present in the network. The edges connect one gene to one term.}
}
}
\description{
Create a list containing all node and edge information needed
to create the network
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retained the GO Molecular Function results
results <- parentalNapaVsDMSOEnrichment$result[
        parentalNapaVsDMSOEnrichment$result$source == "GO:MF", ]

## Extract node and edge information
information <-
    enrichViewNet:::extractNodesAndEdgesInformation(
        gostResults=results, gostObject=parentalNapaVsDMSOEnrichment)

}
\author{
Astrid Deschênes
}
\keyword{internal}
