% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichViewNet.R
\docType{data}
\name{demoGOST}
\alias{demoGOST}
\title{The result of a functional enrichment analysis done with \code{gprofiler2} 
(\url{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}).}
\format{
The \code{list} contains two entries. The \code{result} entry 
contains a \code{data.frame} with the significant results obtained by
an enrichment analysis done with \code{gprofiler2}. The \code{meta} entry 
contains a named list with all the metadata for the query.
}
\usage{
data(demoGOST)
}
\value{
A \code{list} containing two entries. The \code{result} entry 
contains a \code{data.frame} with the significant results obtained by
an enrichment analysis done with \code{gprofiler2}. 
The \code{meta} entry contains a named list with all the 
metadata for the query.
}
\description{
The object is a \code{list} with 2 entries. It contains the results of the
enrichment analysis as well as the metadata related to the analysis.
}
\details{
This dataset can be
used to test the \code{\link{createNetwork}} function.
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(demoGOST)

## Create network for WikiPathways results 
## in Cytoscape (if the application is open)
## Otherwise, create a CX file in the temporary directory
## The file can be opened in Cytoscape
createNetwork(gostObject=demoGOST, source="WP", title="Wikipathways",
    fileName=file.path(tempdir(), "Wikipathways_Demo.cx"))


}
\seealso{
\itemize{
    \item{\link{createNetwork} for transforming functional 
    enrichment results from gprofiler2 into a Cytoscape network}
    \item{\link{createEnrichMap} for transforming functional 
    enrichment results from gprofiler2 into an enrichment map}
}
}
\keyword{datasets}
