% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsInternal.R
\encoding{UTF-8}
\name{createCXJSONForCytoscape}
\alias{createCXJSONForCytoscape}
\title{Create CX JSON text representing the network}
\usage{
createCXJSONForCytoscape(nodeEdgeInfo, title)
}
\arguments{
\item{nodeEdgeInfo}{a \code{list} created by gprofiler2 that contains
the results from an enrichment analysis. TODO}

\item{title}{a \code{character} string representing the name assigned to
the network.}
}
\value{
\code{character} string that represent the network in a CX JSON
format.
}
\description{
Create a CX JSON text that represent the network which
includes information about nodes and edges present in the network.
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retained the GO Molecular Function results
results <- parentalNapaVsDMSOEnrichment$result[
        parentalNapaVsDMSOEnrichment$result$source == "GO:MF", ]

## Extract node and edge information
information <- enrichViewNet:::extractInformationWhenIntersection(
        gostResults=results)

jsonFormat <- enrichViewNet:::createCXJSONForCytoscape(
                nodeEdgeInfo=information, title="WikiPathways")

}
\author{
Astrid Deschênes
}
\keyword{internal}
