% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryEncode.R
\name{queryEncode}
\alias{queryEncode}
\title{query data from ENCODE by predefined criteria}
\usage{
queryEncode(
  exactMatch,
  partialMatch = character(0),
  API_url = "https://www.encodeproject.org/search/",
  ...
)
}
\arguments{
\item{exactMatch}{character. Exact-match keywords refer to search results
that perfectly match all the keywords in the search query, exactly as
entered. It is a named character vector. The names will be the keys
and characters will be the values for search.}

\item{partialMatch}{character. Partial-match refer to search results that
contain the search query. It is a named character vector.
The names will be the keys and characters will be the values for search.
The value starting from '!' indicates logical negation(NOT).
The value starting from '>', '>=', '<', '==', '<=' indicates string
comparison.}

\item{API_url}{character. The ENCODE REST API url.}

\item{...}{Not used.}
}
\value{
A list of search results
}
\description{
Search ENCODE data by querying the ENCODE Portal using its
REST API.
}
\examples{
res <- queryEncode(
 exactMatch=c(
  target.label="H3K4me1",
  replicates.library.biosample.donor.organism.scientific_name="Homo sapiens",
  assembly="GRCh38",
  assay_term_name="ChIP-seq"),
  partialMatch=c(biosample_summary="heart"))
}
