% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTx2Gene.R
\name{getTx2Gene}
\alias{getTx2Gene}
\title{Generate a transcript-to-gene mapping from a GRangesList}
\usage{
getTx2Gene(grl, filepath = NULL)
}
\arguments{
\item{grl}{\code{GRangesList} object, typically generated by
\code{getFeatureRanges}}

\item{filepath}{Either \code{NULL} or the path to a file where the
transcript-to-gene mapping will be written}
}
\value{
Invisibly returns a \code{data.frame} with the transcript-to-gene
mapping.
}
\description{
Generate a \code{data.frame} mapping transcript IDs to gene IDs, based on
a GRangesList object generated by \code{getFeatureRanges}.
}
\examples{
  ## Get feature ranges
  grl <- getFeatureRanges(
    gtf = system.file("extdata/small_example.gtf", package = "eisaR"),
    featureType = c("spliced", "intron"),
    intronType = "separate",
    flankLength = 5L,
    joinOverlappingIntrons = FALSE,
    verbose = TRUE
  )
  
  ## Get transcript-to-gene mapping
  t2g <- getTx2Gene(grl = grl)
  t2g
   
}
\author{
Charlotte Soneson
}
