% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMethods.R, R/setMethods.R
\docType{methods}
\name{qvalueObj}
\alias{qvalueObj}
\alias{qvalueObj,deSet-method}
\alias{qvalueObj<-}
\alias{qvalueObj<-,deSet-method}
\title{Access/set qvalue slot}
\usage{
qvalueObj(object)

qvalueObj(object) <- value

\S4method{qvalueObj}{deSet}(object)

\S4method{qvalueObj}{deSet}(object) <- value
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deSet}}}

\item{value}{S3 \code{object}: \code{\link{qvalue}}}
}
\value{
\code{qvalueObj} returns a \code{\link{qvalue}} object.
}
\description{
These generic functions access and set the \code{qvalue} object in the
\code{\linkS4class{deSet}} object.
}
\examples{
# import data
library(splines)
library(qvalue)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# run the odp method
de_odp <- odp(de_obj, bs.its = 20)

# extract out significance results
qval_obj <- qvalueObj(de_odp)

# run qvalue and assign it to deSet slot
pvals <- qval_obj$pvalues
qval_new <- qvalue(pvals, pfdr = TRUE, fdr.level = 0.1)
qvalueObj(de_odp) <- qval_new

}
\author{
John Storey, Andrew Bass
}
\seealso{
\code{\link{lrt}}, \code{\link{odp}} and
\code{\linkS4class{deSet}}
}

