% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/deSet-methods.R
\docType{methods}
\name{fit_models}
\alias{fit_models}
\alias{fit_models,deSet-method}
\title{Linear regression of the null and full models}
\usage{
fit_models(object, stat.type = c("lrt", "odp"), weights = NULL)

\S4method{fit_models}{deSet}(object, stat.type = c("lrt", "odp"),
  weights = NULL)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deSet}}.}

\item{stat.type}{\code{character}: type of statistic to be used. Either
"lrt" or "odp". Default is "lrt".}

\item{weights}{\code{matrix}: weights for each observation. Default is NULL.}
}
\value{
\code{\linkS4class{deFit}} object
}
\description{
\code{fit_models} fits a model matrix to each gene by using the least
squares method. Model fits can be either statistic type "odp" (optimal
discovery procedure) or "lrt" (likelihood ratio test).
}
\details{
If "odp" method is implemented then the null model is removed from the full 
model (see Storey 2007).  Otherwise, the statistic type has no affect on the
model fit.
}
\note{
\code{fit_models} does not have to be called by the user to use
\code{\link{odp}}, \code{\link{lrt}} or \code{\link{kl_clust}} as it is an
optional input and is implemented in the methods. The
\code{\linkS4class{deFit}} object can be created by the user if a different
statistical implementation is required.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# retrieve statistics from linear regression for each gene
fit_lrt <- fit_models(de_obj, stat.type = "lrt") # lrt method
fit_odp <- fit_models(de_obj, stat.type = "odp") # odp method

# summarize object
summary(fit_odp)

}
\author{
John Storey
}
\references{
Storey JD. (2007) The optimal discovery procedure: A new approach to
simultaneous significance testing. Journal of the Royal Statistical
Society, Series B, 69: 347-368.

Storey JD, Dai JY, and Leek JT. (2007) The optimal discovery procedure for
large-scale significance testing, with applications to comparative
microarray experiments. Biostatistics, 8: 414-432.

Storey JD, Xiao W, Leek JT, Tompkins RG, and Davis RW. (2005) Significance
analysis of time course microarray experiments. Proceedings of the National
Academy of Sciences, 102: 12837-12842.
}
\seealso{
\code{\linkS4class{deFit}}, \code{\link{odp}} and
\code{\link{lrt}}
}

