% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_models.R
\name{build_models}
\alias{build_models}
\title{Generate a deSet object with full and null models}
\usage{
build_models(data, cov, full.model = NULL, null.model = NULL, ind = NULL)
}
\arguments{
\item{data}{\code{matrix}: gene expression data.}

\item{cov}{\code{data.frame}: the covariates in the study.}

\item{full.model}{\code{formula}: the adjustment and the biological
variables of interest.}

\item{null.model}{\code{formula}: the adjustment variables.}

\item{ind}{\code{factor}: individuals sampled in the study. Default is
NULL. Optional.}
}
\value{
\code{\linkS4class{deSet}} object
}
\description{
\code{build_models} creates a \code{\link{deSet}} object. The user inputs
the full and null models.
}
\examples{
# create ExpressionSet object from kidney dataset
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null.model <- ~sex
full.model <- ~sex + ns(age, df=4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null.model,
full.model = full.model)
}
\author{
John Storey, Andy Bass
}
\seealso{
\code{\linkS4class{deSet}}, \code{\link{build_study}}
}

