% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/deSet-methods.R
\docType{methods}
\name{apply_qvalue}
\alias{apply_qvalue}
\alias{apply_qvalue,deSet-method}
\title{Estimate the q-values for a given set of p-values}
\usage{
apply_qvalue(object, ...)

\S4method{apply_qvalue}{deSet}(object, ...)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deSet}}}

\item{...}{Additional arguments for \code{\link{qvalue}}}
}
\value{
\code{\linkS4class{deSet}} object with slots updated by \code{\link{qvalue}}
 calculations.
}
\description{
Runs \code{\link{qvalue}} on a \code{\linkS4class{deSet}} object.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# Run lrt (or odp) and apply_qvalue
de_lrt <- lrt(de_obj)
de_lrt <- apply_qvalue(de_lrt, fdr.level = 0.05,
pi0.method = "bootstrap", adj=1.2)
summary(de_lrt)

}
\author{
John Storey, Andrew Bass
}
\references{
Storey JD and Tibshirani R. (2003) Statistical significance for
genome-wide studies. Proceedings of the National Academy of Sciences,
100: 9440-9445
}
\seealso{
\code{\linkS4class{deSet}}, \code{\link{odp}} and
\code{\link{lrt}}
}

