% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{mkdCodeChunkSt,easyreporting-method}
\alias{mkdCodeChunkSt,easyreporting-method}
\title{mkdCodeChunkSt}
\usage{
\S4method{mkdCodeChunkSt}{easyreporting}(
  object,
  optionList = getOptionsList(object),
  sourceFilesList = NULL,
  isComplete = FALSE
)
}
\arguments{
\item{object}{an easyreporting class object}

\item{optionList}{a list of options}

\item{sourceFilesList}{a list of files that can be sourced inside the code
chunk.}

\item{isComplete}{a flag determining if the chunk is already a complete chunk}
}
\value{
none
}
\description{
it creates a code chunk start. A list of options and files to
source  for the chunk can optionally be passed to the function.
}
\examples{
\dontrun{
rd <- easyreporting(filenamePath="./project_report",
                        title="example_report", author=c("It's me"))
## no options
mkdCodeChunkSt(rd)
## just leaving empty
mkdCodeChunkEnd(rd)

## setting options
optList <- makeOptionsList(includeFlag=TRUE)
mkdCodeChunkSt(rd, optionList=optList)
## just leaving empty
mkdCodeChunkEnd(rd)
}
}
