% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracing.R
\name{mkdCodeChunkCommented,easyreporting-method}
\alias{mkdCodeChunkCommented,easyreporting-method}
\title{mkdCodeChunkCommented}
\usage{
\S4method{mkdCodeChunkCommented}{easyreporting}(
  object,
  comment = NULL,
  code,
  optionList = getOptionsList(object),
  sourceFilesList = NULL
)
}
\arguments{
\item{object}{an easyreporting class object}

\item{comment}{a string with the natural language comment for the chunk.}

\item{code}{a string within the code.}

\item{optionList}{a list of options (default is the class options).}

\item{sourceFilesList}{a optional list of files to source inside the chunk.}
}
\value{
none
}
\description{
it creates a complete code chunk, adding a natural language
comment before of it.
}
\examples{
\dontrun{
rd <- easyreporting(filenamePath="./project_report",
                        title="example_report", author=c("It's me"))
optList <- makeOptionsList(includeFlag=TRUE, cacheFlag=TRUE)
mkdCodeChunkCommented(rd,
                comment="This is the comment of the following code chunk",
                code=c(quote(a <- 1), quote(b <- 2), quote(c <- a+b)), 
                optionList=optList, sourceFilesList=NULL)
mkdCodeChunkCommented(rd,
                comment="This is the comment of the following code chunk",
                code="a <- 1\n b <- 2\n(c <- a+b)\n", optionList=optList,
                sourceFilesList=NULL)
}
}
