% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyRNASeq-coverage-methods.R
\name{easyRNASeq coverage methods}
\alias{easyRNASeq coverage methods}
\alias{fetchCoverage-deprecated}
\title{Compute the coverage from a Short Read Alignment file}
\usage{
\S4method{fetchCoverage}{RNAseq}(
  obj,
  format = c("aln", "bam"),
  filename = character(1),
  filter = srFilter(),
  type = "SolexaExport",
  chr.sel = c(),
  validity.check = TRUE,
  chr.map = data.frame(),
  ignoreWarnings = FALSE,
  gapped = TRUE,
  paired = FALSE,
  stranded = FALSE,
  bp.coverage = FALSE,
  ...
)
}
\arguments{
\item{obj}{An \code{\linkS4class{RNAseq}} object}

\item{format}{The format of the reads, one of "aln","bam". If not "bam",
all the types supported by the ShortRead package are supported too.}

\item{filename}{The full path of the file to use}

\item{filter}{The filter to be applied when loading the data using the
"aln" format}

\item{type}{The type of data when using the "aln" format. See the
\pkg{ShortRead} package.}

\item{chr.sel}{A vector of chromosome names to subset the final results.}

\item{validity.check}{Shall UCSC chromosome name convention be enforced}

\item{chr.map}{A data.frame describing the mapping of original chromosome
names towards wished chromosome names. See details.}

\item{ignoreWarnings}{set to TRUE (bad idea! they have a good reason to be
there) if you do not want warning messages.}

\item{gapped}{Is the bam file provided containing gapped alignments?}

\item{paired}{Is the bam file containing PE reads?}

\item{stranded}{Is the bam file from a strand specific protocol?}

\item{bp.coverage}{a boolean that default to FALSE to decide whether
coverage is to be calculated and stored by bp}

\item{...}{additional arguments. See details}
}
\value{
An \code{\linkS4class{RNAseq}} object. The slot readCoverage
contains a SimpleRleList object representing a list of coverage vectors,
one per chromosome.
}
\description{
Computes the genomic reads' coverage from a
read file in bam format or any format supported by \pkg{ShortRead}.
}
\details{
\dots{} for fetchCoverage: Can be used for readAligned method from package
\pkg{ShortRead}. The use of the dots for the scanBamFlag method from package
\pkg{Rsamtools} has been deprecated, as were the 'what' and 'isUnmappedQuery'
argument to the function
}
\examples{

  \dontrun{
	library("RnaSeqTutorial")
	library(BSgenome.Dmelanogaster.UCSC.dm3)

	obj <- new('RNAseq',
		organismName="Dmelanogaster",
		readLength=36L,
		chrSize=as.list(seqlengths(Dmelanogaster))
		)

	obj <- fetchCoverage(
			obj,
			format="bam",
                        filename=system.file(
				"extdata",
				"ACACTG.bam",
                            	package="RnaSeqTutorial")
			)
	}

}
\seealso{
\code{\linkS4class{Rle}}
\code{\link[ShortRead:readAligned]{ShortRead:readAligned}}
}
\author{
Nicolas Delhomme
}
\keyword{methods}
