% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicRanges-methods.R
\name{easyRNASeq GenomicRanges package extension}
\alias{easyRNASeq GenomicRanges package extension}
\alias{colnames}
\alias{colnames,GRanges-method}
\alias{colnames,GRangesList-method}
\alias{unsafeAppend}
\alias{unsafeAppend,GAlignments,GAlignments-method}
\title{Extension of the GenomicRanges package}
\usage{
colnames(x, do.NULL = TRUE, prefix = "col")
unsafeAppend(obj1,obj2)
}
\arguments{
\item{x}{An object of the \code{\linkS4class{GRanges}} or
\code{\linkS4class{GRangesList}} class}

\item{do.NULL}{see \code{\link[BiocGenerics]{row_colnames}} for details}

\item{prefix}{see \code{\link[BiocGenerics]{row_colnames}} for details}

\item{obj1}{A \code{\linkS4class{GAlignments}} object}

\item{obj2}{A \code{\linkS4class{GAlignments}} object}
}
\value{
\itemize{
\item \code{colnames}: A vector of column names.
\item \code{unsafeAppend}: A \code{\linkS4class{GAlignments}} object
}
}
\description{
Describes extensions to the \code{\link[GenomicRanges:GRanges-class]{GenomicRanges}} package.
For \code{\linkS4class{GRanges}} and
\code{\linkS4class{GRangesList}} objects:
\itemize{
\item \code{colnames} returns the column name of a \code{\linkS4class{GRanges}} or
\code{\linkS4class{GRangesList}} object.
\item \code{unsafeAppend} appends two \code{\linkS4class{GAlignments}}
  object together bypassing most sanity checks. Faster than the standard \code{c} or
  \code{append} function.
}
}
\details{
\itemize{
\item \code{colnames} returns the actual column names of the elementMetadata slot of the
\code{\linkS4class{GRanges}} or \code{\linkS4class{GRangesList}} object.
The elementMetadata contains a \code{\linkS4class{DataFrame}} object used
to store additional information provided by the user, such as exon ID in
our case.
  \item \code{unsafeAppend} appends two \code{\linkS4class{GAlignments}} objects.
}
}
\examples{

 # an example of annotation
	grngs <- GRanges(seqnames=c("chr01","chr01","chr02"),
                     ranges=IRanges(
                             start=c(10,30,100),
                             end=c(21,53,123)),
                          strand=c("+","+","-"),
                          transcripts=c("trA1","trA2","trB"),
                          gene=c("gA","gA","gB"),
                          exon=c("e1","e2","e3")
                          )

	# accessing the colnames
	colnames(grngs)

	# creating a GRangesList
	grngsList<-split(grngs,seqnames(grngs))

	# accessing the colnames
	colnames(grngsList)

# For unsafeAppend
library(GenomicAlignments)
unsafeAppend(GAlignments(),GAlignments())

}
\seealso{
\itemize{
\item \code{\linkS4class{DataFrame}}
\item \code{\linkS4class{GRanges}}
\item \code{\linkS4class{GRangesList}}
\item \code{\linkS4class{GAlignments}}
\code{\link[BiocGenerics]{row_colnames}}
}
}
\author{
Nicolas Delhomme
}
\keyword{methods}
