% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_OE_bulk.R
\name{get_OE_bulk}
\alias{get_OE_bulk}
\title{Compute overall expression (OE) of the immune
resistance program used in the computation of
repressed immune resistance signature (RIR) score.}
\usage{
get_OE_bulk(
  r,
  gene_sign = NULL,
  num_rounds = 1000,
  full_flag = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{r}{list containing a numeric matrix with bulk RNA-Seq
data (tpm values) and a character string with the available
gene names.}

\item{gene_sign}{list containing different character strings
associated with subsets of the resistance program.}

\item{num_rounds}{integer value related to the number of random
gene signatures samples to be computed for normalization.
Original work indicates that 1000 random signatures were sufficient
to yield an estimate of the expected value.}

\item{full_flag}{logical flag indicating whether to return also
random scores.}

\item{verbose}{logical flag indicating whether to display messages
about the process.}
}
\value{
A numeric matrix with computed scores for each sample and
subset of signatures included in the immune resistance program
(rows = samples; columns = gene signatures)
}
\description{
This function calculates the overall expression of
the immune resistance program which is based on a set
of gene signatures associated with T cell exclusion,
post-treatment and functional resistance.
}
\details{
The source code was provided by original work:
https://github.com/livnatje/ImmuneResistance
}
\examples{
\donttest{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")

dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()
RNA_tpm <- assays(dataset_mariathasan)[["tpm"]]

# Select a subset of patients to reduce vignette building time.
pat_subset <- c(
  "SAM76a431ba6ce1", "SAMd3bd67996035", "SAMd3601288319e",
  "SAMba1a34b5a060", "SAM18a4dabbc557"
)
RNA_tpm <- RNA_tpm[, colnames(RNA_tpm) \%in\% pat_subset]

# Log2 transformation:
log2_RNA_tpm <- log2(RNA_tpm + 1)

# Prepare input data
r <- list()
r$tpm <- log2_RNA_tpm
r$genes <- rownames(log2_RNA_tpm)

# Gene signature of immune resistance program
score_signature_genes <- suppressMessages(easierData::get_scores_signature_genes())
RIR_gene_signature <- score_signature_genes$RIR

# Apply function to calculate OE:
res_scores <- get_OE_bulk(r, gene_sign = RIR_gene_signature, verbose = TRUE)
}
}
\references{
Jerby-Arnon, L., Shah, P., Cuoco, M.S.,
Rodman, C., Su, M.-J., Melms, J.C., Leeson, R., Kanodia,
A., Mei, S., Lin, J.-R., et al. (2018). A Cancer Cell
Program Promotes T Cell Exclusion and Resistance to
Checkpoint Blockade. Cell 175, 984–997.e24.
https://doi.org/10.1016/j.cell.2018.09.006.
}
